## Where Set Clause Exists

More about the slicer as a set of tuples : i.e., behaviors related to tuple exists mechanism.




### Description

This section highlights several usage of the slicer related to tuple completion and exists mechanisms (i.e., tuple with several members of the same dimension).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member : tuple completion (1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated members are completed with the slicer content. Note, that hierarchies of the same dimension are also completed.

In our example, the slicer members [Geo].[France] and [United States] are completing the [Economy] hierarchy members in the calculated member [sliced].

**Query**

```
WITH
    MEMBER [Measures].[sliced] AS Sum( [Geography].[Economy].[Country].members, [Measures].[Amount] )
SELECT
    { [Measures].[amount], [Measures].[sliced] } on 0
FROM
    [Sales]
WHERE
    { ([Geography].[Geo].[France]),([Geography].[Geo].[United States]) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">sliced</td>
</tr>
<tr>
 <td>772</td>
 <td>772</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[france+us]     AS ( [Geography].[Economy].[France], [Measures].[Amount] ) + ( [Geography].[Economy].[United States], [Measures].[Amount] )
SELECT
    { [Measures].[france+us], [Measures].[france+us] } on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member : tuple completion (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar as the former example but using a set of tuples instead of a set of members.

**Query**

```
WITH
    MEMBER [Measures].[sliced] AS ( [Geography].[Economy].defaultMember, [Measures].[Amount] )
SELECT
    { [Measures].[amount], [Measures].[sliced] } on 0
FROM
    [Sales]
WHERE
    { ( [Geography].[Geo].[France],[Product].[Prod].[Personal] ), ( [Geography].[Geo].[Switzerland],[Product].[Prod].[Corporate] ) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">sliced</td>
</tr>
<tr>
 <td>148</td>
 <td>148</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[france+switzerland] AS ( [Geography].[Economy].[France],[Product].[Prod].[Personal], [Measures].[Amount] ) + ( [Geography].[Economy].[Switzerland],[Product].[Prod].[Corporate], [Measures].[Amount] )
SELECT
    { [Measures].[france+switzerland], [Measures].[france+switzerland] } on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member : currentMember and set of members

</div>

<div class="ic3-mdx-example-body" style="display:none">

As the slicer is defining several countries, currentMember called by the calculated member is failing.

**Query**

```
WITH
    MEMBER [Measures].[france+spain] AS Sum( ( [Geography].[Economy].[Country].members, [Geography].[Geo].currentMember ), [Measures].[Amount] )
SELECT
    { [Measures].[france+spain] } on 0
FROM
    [Sales]
WHERE
    { ([Geography].[Geo].[France]),([Geography].[Geo].[Spain]) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">france+spain</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_SLICER_SET_CURRENT_MEMBER)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_SLICER_SET_CURRENT_MEMBER](icCubeError.md#olap_slicer_set_current_member)<br>Error Message : more than one current member (from the slicer) for hierarchy '[Geography].[Geo]'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchy both in a calculated member and in one axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

Another example of tuple completion and filtering.

In our example, the slicer filters the members function of axis 0 and applies to the calculated member [xx].

**Query**

```
WITH                                                          
    MEMBER [Measures].[xx] AS Sum( [Geography].[Economy].[Country].members, [Measures].[Amount] )
SELECT
    [Geography].[Economy].members on 0,
    { [Measures].[Amount], [Measures].[xx] } on 1
FROM
    [Sales]
WHERE
    { ( [Geography].[Geo].[France] ), ( [Geography].[Geo].[Spain] ) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">ALL</td>
  <td class="ic3-mdx-result-cell-header">EU</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount</td>
 <td>7</td>
 <td>7</td>
 <td>4</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">xx</td>
 <td>7</td>
 <td>7</td>
 <td>7</td>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[sliced-amount] AS
        Iif( [Geography].[Economy].currentMember.level IS [Geography].[Economy].[Country],
             ( [Geography].[Economy].currentMember, [Measures].[Amount] ) ,
             ( [Geography].[Economy].[France], [Measures].[Amount] ) + ( [Geography].[Economy].[Spain], [Measures].[Amount] )
        )


    MEMBER [Measures].[xx] AS ( [Geography].[Economy].[Spain], [Measures].[Amount] ) + ( [Geography].[Economy].[France], [Measures].[Amount] )

SELECT
    Hierarchize( Ascendants( [Geography].[Economy].[France] ) + Ascendants( [Geography].[Economy].[Spain] )) on 0,
    { [Measures].[sliced-amount], [Measures].[xx] } on 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated members using a named set

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is being evaluated according to the slicer context and as for the axis an auto-exists is applied to all
set members (e.g. only economy members matching [France] and [Spain] are accepted). Note, how in the context
of a calculated member the slicer auto-exists is not applied.

**Query**

```
WITH
    MEMBER [Measures].[Set Count] AS Count( [my-set] )
    MEMBER [Measures].[No Set Count] AS Count( [Geography].[Economy].members )
    SET [my-set] AS [Geography].[Economy].members
SELECT
    { [Set Count], [No Set Count] } on 0,
    [Geography].[Economy].members on 1
FROM [Sales]
WHERE {[Geography].[Geo].[Country].[France] ,[Geography].[Geo].[Country].[Spain]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Set Count</td>
  <td class="ic3-mdx-result-cell-header">No Set Count</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">ALL</td>
 <td>4</td>
 <td>11</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;EU</td>
 <td>4</td>
 <td>11</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
 <td>11</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>4</td>
 <td>11</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
	MEMBER [Measures].[Set Count] AS Count( Extract([Geography].[Economy].members  * {[Geography].[Geo].[Country].[France] ,[Geography].[Geo].[Country].[Spain]}, [Geography].[Economy]) )
	MEMBER [Measures].[No Set Count] AS Count( [Geography].[Economy].members )
    SET [my-set] AS [Geography].[Economy].members
SELECT
	{ [Set Count], [No Set Count] } on 0,
    Extract([Geography].[Economy].members  * {[Geography].[Geo].[Country].[France] ,[Geography].[Geo].[Country].[Spain]}, [Geography].[Economy])  on 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Showing the dimension is filtered

</div>

<div class="ic3-mdx-example-body" style="display:none">

Within the axis evaluation, the dimension [Geography] members are filtered according to the slicer content.

**Query**

```
SELECT
    Head( [Time].[Calendar].[Month].members , Count( [Geography].[Economy].members )) on 0
FROM
    [Sales]
WHERE
    { ([Geography].[Geo].[France]), ([Geography].[Geo].[Spain]) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
</tr>
<tr>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Head( [Time].[Calendar].[Month].members , Count( Ascendants( [Geography].[Economy].[France] ) + Ascendants( [Geography].[Economy].[Spain]) )) on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Axis processing using cell evaluations

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar to calculated member behavior : dimensions are overwritten by the actual slicer content.

In our example, [Economy].[All] is evaluated as the tuple ([Economy].[All],[Geo].[France]+[Geo].[Spain]).

**Query**

```
SELECT
    Iif( [Geography].[Economy].[All] = 7, [Time].[Calendar].[2010], [Time].[Calendar].[2011] ) on 0
    --                                 ^
    --                        the value of [France] + [Spain]
FROM
    [Sales]
WHERE
    { ([Geography].[Geo].[France]), ([Geography].[Geo].[Spain]) }
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
  MEMBER [france+spain 2010] AS ([Time].[Calendar].[2010], [Geography].[Geo].[France],[Measures].[Amount]) + ([Time].[Calendar].[2010], [Geography].[Geo].[Spain],[Measures].[Amount])
SELECT [france+spain 2010] on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Where Clause](Where%20Clause.md)

[Where Clause Exists](Where%20Clause%20Exists.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
